/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.result;

import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;

public class CapacityUsageGorTableRow
implements Comparable<CapacityUsageGorTableRow> {
    private final GeneralizedOrderRequest gor;
    private final String capabilities;
    private final long used;
    private final double usedRatio;

    public CapacityUsageGorTableRow(GeneralizedOrderRequest gor, String capabilities, long used, double usedRatio) {
        this.gor = gor;
        this.capabilities = capabilities;
        this.used = used;
        this.usedRatio = usedRatio;
    }

    public String getGorId() {
        return this.gor.getId();
    }

    public String getProductName() {
        return this.gor.getProduct().getName();
    }

    public String getProductDescription() {
        return this.gor.getProduct().getDescription();
    }

    public double getQty() {
        return this.gor.getRequestedQty();
    }

    public long getReleaseDate() {
        return this.gor.getReleaseDate();
    }

    public long getDueDate() {
        return this.gor.getDueDate();
    }

    public long getOffset() {
        if (GeneralizedRequest.isDateValid(this.gor.getEndDate())) {
            return this.gor.getDueDate() - this.gor.getEndDate();
        }
        return 0L;
    }

    public String getCapabilities() {
        return this.capabilities;
    }

    public long getUsed() {
        return this.used;
    }

    public double getUsedRatio() {
        return this.usedRatio;
    }

    @Override
    public int compareTo(CapacityUsageGorTableRow o) {
        return this.gor.getId().compareTo(o.gor.getId());
    }
}

